﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace CS_iSMS_Receive_Multiple_API_Polling_Mode
{
    public partial class MainForm : Form
    {
        // The iSMShttp class is used to send messages and queries to iSMS using HTTP.
        private iSMShttp doHTTP = new iSMShttp();
        // The iSMStcp class is used to send messages and queries to iSMS using TCP.
        private iSMStcp doTCP = new iSMStcp();
        // The iSMSParser class is used to parse status and error responses from the iSMS.
        private iSMSParser doParser = new iSMSParser();
        // The iSMSparseXML class is used to parse message info from XML responses from the iSMS.
        private iSMSparseXML doParseXML = new iSMSparseXML();
             
                
        // The query string sent to iSMS to get count of messages with filters
        private String smsQueryCount = "";
        // The query string sent to iSMS to receive messages with filters
        private String smsRecvMsg = "";
        
        // Whether the query should be sent using HTTP. False=TCP.
        private bool isHTTP = true;
        
        // Used by timer function to track iSMS IP address when using TCP.
        private String tcpIPAddress = "";
        // Used by timer function to track iSMS Port when using TCP.
        private int tcpPort = 2040;
              

        public MainForm()
        {
            InitializeComponent();
            // Initialize Protocol Combo Box
            Protocol_comboBox.Items.Add("HTTP");
            Protocol_comboBox.Items.Add("TCP");
            Protocol_comboBox.SelectedIndex = 0;

            // Set some default values in SMS info dialogs for convenience
            Port_textBox.Text = "80";
            User_textBox.Text = "admin";
            Passwd_textBox.Text = "admin";
            IPAddress_textBox.Text = "192.168.1.2";
            //To_textBox.Text = "7637853500";
            //Message_richTextBox.Text = "TestSMS";
        }

        // This function is called when the Get Message Count button is clicked
        private void GetCount_button_Click(object sender, EventArgs e)
        {   
            // Call function to querycount iSMS and display count in text box
            Count_textBox.Text = GetMessageCount().ToString();  
        }


        // This function is called when the Next Message is clicked.
        // This program will retreive all available messages that match the current filters.
        private void GetNextMessage_button_Click_1(object sender, EventArgs e)
        {   
            // Create a iSMSmessage class that will be used to store message info.
            iSMSmessage theSMS = new iSMSmessage();

            // Call function to create the SMS query messages with filters.
            if (CreateiSMSMessages() == -1) return;

            // Display Recvmsg being sent to iSMS in iSMS Message Log
            iSMSlog_richTextBox.Text = "Recv message sent to iSMS:\n" + smsRecvMsg + "\n";

            // Send recvmsg message to iSMS
            String iSMSresponse = "";
            if (isHTTP)
                iSMSresponse = doHTTP.SendHTTPMessage(smsRecvMsg); // Use HTTP
            else
                iSMSresponse = doTCP.SendTCPMessage(tcpIPAddress, tcpPort, smsRecvMsg); // Use TCP
            // Display iSMS raw response to recvmsg
            iSMSlog_richTextBox.AppendText("\niSMS response to Recv Message:\n" + iSMSresponse);

            // Call function to parse message count from messages receieved.
            int MessageCount = doParseXML.GetMessageCount(iSMSresponse);
            // Clear message table
            Messages_dataGridView.Rows.Clear();
            // If no messages received exit.
            if (MessageCount < 1) return;
            // Display number of messages retreived.
            Count_textBox.Text = MessageCount.ToString();

            // Add Rows for messages
            Messages_dataGridView.Rows.Add(MessageCount);
            // Cycle through messages and fill in message table.
            for (int i = 0; i < MessageCount; i++)
            {
                // Parsing messages one at time.
                theSMS = doParseXML.GetMessage(iSMSresponse, i+1);
                // Fill in table.
                Messages_dataGridView.Rows[i].Cells[0].Value = theSMS.MessageIndex;
                if (theSMS.SenderNumber.StartsWith("+")) // Remove + from SenderNumber before displaying
                    Messages_dataGridView.Rows[i].Cells[1].Value = theSMS.SenderNumber.TrimStart("+".ToCharArray());
                else
                    Messages_dataGridView.Rows[i].Cells[1].Value = theSMS.SenderNumber;
                Messages_dataGridView.Rows[i].Cells[2].Value = theSMS.Date;
                Messages_dataGridView.Rows[i].Cells[3].Value = theSMS.Time;
                Messages_dataGridView.Rows[i].Cells[4].Value = theSMS.EncodingFlag;
                Messages_dataGridView.Rows[i].Cells[5].Value = theSMS.Message;
            }
        }

        // This function sends a query count to iSMS, and returns the message count as an int.
        private int GetMessageCount()
        {
            if (CreateiSMSMessages() == -1) return 0; // If creation of messages fails, then return.

            iSMSlog_richTextBox.Text = "Query Count message sent to iSMS:\n" + smsQueryCount + "\n";

            // Send querycount message to iSMS
            String iSMSresponse = "";
            if (isHTTP)
                iSMSresponse = doHTTP.SendHTTPMessage(smsQueryCount); // Send using HTTP
            else
                iSMSresponse = doTCP.SendTCPMessage(tcpIPAddress, tcpPort, smsQueryCount); // Send using TCP

            // Display raw response in iSMS Message log
            iSMSlog_richTextBox.AppendText("\niSMS response to Query Count:\n" + iSMSresponse);

            // Get the message count from raw iSMS response
            int smsCount = doParser.ParseCount(iSMSresponse);
            if (smsCount < 0)
            {   // Error occured when doing querycount. Display error
                iSMSlog_richTextBox.AppendText("\nQuert count reveiced error:\n" + doParser.GetErrorDesc(iSMSresponse));
                return 0;
            }
            return smsCount;
        }


        // This function creates the queries and messages that will be set to iSMS, with filters.
        // It will also set the isHTTP flag and set the tcpIPAddress/tcpPort.
        private int CreateiSMSMessages()
        {   // Check combo box for HTTP or TCP setting
            if ((string)Protocol_comboBox.SelectedItem == "HTTP")
                isHTTP = true; // Use HTTP
            else
                isHTTP = false; // Use TCP
            
            String ErrorList = ""; // Used to create a list of required fields not filled in.
            // Get data from dialog items and verify that all dialogs were filled in.
            // Prep SMS info strings to make build SMS message easier later.
            if (IPAddress_textBox.Text.Length < 4) // IP Address not filled in
                ErrorList = ErrorList + "IP Address, "; 

            if (Port_textBox.Text.Length < 1) // Port not filled in
                ErrorList = ErrorList + "Port number, ";

            if (User_textBox.Text.Length < 1) // Username not filled in
                ErrorList = ErrorList + "Username, ";

            if (Passwd_textBox.Text.Length < 1) // Password not filled in
                ErrorList = ErrorList + "Password, ";

            // Check if there were errors checking text boxes.
            if (ErrorList.Length > 1)
            {
                ErrorList = "Please enter " + ErrorList + "and try again.";
                System.Windows.Forms.MessageBox.Show(ErrorList);
                return -1; // Return failure
            }

            // Set tcpIPAdress/tcp Port, and prep strings for easier query/message building later. 
            tcpIPAddress = IPAddress_textBox.Text;
            
            string smsPort = Port_textBox.Text;
            tcpPort = Convert.ToInt32(smsPort = Port_textBox.Text, 10);
            smsPort = ":" + smsPort;

            string smsUsername = "user=" + User_textBox.Text;
            string smsPassword = "&passwd=" + Passwd_textBox.Text;

            // Call function to create a string with filters formated for queries and messages.
            String Filters = CreateMessageFilterString();

            if (isHTTP)
            {   // Build querycount and recvmsg messages for HTTP.
                smsQueryCount = "http://" + tcpIPAddress + smsPort + "/querycount?" + smsUsername + smsPassword + Filters;
                smsRecvMsg = "http://" + tcpIPAddress + smsPort + "/recvmsg?" + smsUsername + smsPassword + Filters;
            }
            else
            {   // Build querycount and recvmsg messages for TCP.
                smsQueryCount = "/querycount?" + smsUsername + smsPassword + Filters+ "\r\n";
                smsRecvMsg = "/recvmsg?" + smsUsername + smsPassword + Filters + "\r\n";
            }
            
            return 1; // Return success
        }

        // This function creates a string with filters formated for querycount and recvmsg.
        private String CreateMessageFilterString()
        {
            // Filters are not required. So if a filter text box is blank, then skip that fileter.
            String Filters = "";
            if (From_textBox.Text.Length > 0)
            {   // The from phone numbers are received with a leading +. If the from fileter doesn't start with +, then add it.
                if (From_textBox.Text.StartsWith("+"))
                    Filters = Filters + "&from=" + From_textBox.Text;
                else
                    Filters = Filters + "&from=+" + From_textBox.Text;
            }
            if (DateFrom_textBox.Text.Length>0)
                Filters = Filters + "&fdate=" + DateFrom_textBox.Text;
            if (DateTo_textBox.Text.Length>0)
                Filters = Filters + "&tdate=" + DateTo_textBox.Text;
            if (TimeFrom_textBox.Text.Length>0)
                Filters = Filters + "&ftime=" + TimeFrom_textBox.Text;
            if (TimeTo_textBox.Text.Length>0)
                Filters = Filters + "&ttime=" + TimeTo_textBox.Text;
            if (Text_richTextBox.Text.Length>0)
                Filters = Filters + "&text=" + Text_richTextBox.Text;

            return Filters; // Return formated filter string.
        }
             
        
    }
}
